/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.autoregister.api;

import com.miketheshadow.autoregister.annotations.InjectPlugin;
import com.miketheshadow.autoregister.annotations.RegisterCommand;
import com.miketheshadow.autoregister.annotations.RegisterFullCommand;
import com.miketheshadow.autoregister.annotations.RegisterTabComplete;
import com.miketheshadow.autoregister.util.BukkitReflectionUtil;
import com.miketheshadow.autoregister.util.ReflectionBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class AutoRegister
extends ReflectionBase {
    public AutoRegister(Plugin plugin, String packageName, boolean forceRegister) {
        this.plugin = plugin;
        this.packageName = packageName;
        this.force = forceRegister;
    }

    public AutoRegister(Plugin plugin, String packageName) {
        this.plugin = plugin;
        this.packageName = packageName;
    }

    public void start() {
        this.classes = this.collectAllClasses();
    }

    public void defaultSetup() {
        try {
            this.debugLog("Registering listeners...");
            this.registerListeners();
            this.debugLog("Registering commands...");
            this.registerCommands();
            this.debugLog("Registering full commands...");
            this.registerFullCommands();
            this.debugLog("Setup complete!");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Unable to register events with message: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void registerListeners() {
        Set<Class<?>> clazzes = this.getListeners();
        PluginManager manager = Bukkit.getServer().getPluginManager();
        for (Class<?> clazz : clazzes) {
            this.debugLog("Registering listener: " + clazz.getName());
            try {
                Listener listener = (Listener)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                manager.registerEvents(listener, this.plugin);
                try {
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        if (field.getAnnotation(InjectPlugin.class) == null) continue;
                        field.set(listener, this.plugin);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.plugin.getLogger().severe("Unable to register listener: " + clazz.getName() + "!");
                e.printStackTrace();
            }
        }
    }

    public void registerCommands() {
        this.registerBasicCommands();
        this.registerFullCommands();
    }

    public void registerFullCommands() {
        Set<Class<?>> annotatedWithFullRegisterCommandSet = this.getClassesAnnotatedWith(RegisterFullCommand.class);
        ArrayList<Command> commandList = new ArrayList<Command>();
        for (Class<?> clazz : annotatedWithFullRegisterCommandSet) {
            RegisterFullCommand commandAnnotation = clazz.getAnnotation(RegisterFullCommand.class);
            if (commandAnnotation == null) continue;
            String name = commandAnnotation.commandName();
            String description = commandAnnotation.description();
            String usage = commandAnnotation.usageMessage();
            List<String> alias = List.of(commandAnnotation.aliases());
            String permission = commandAnnotation.permission();
            String permissionMessage = commandAnnotation.permissionMessage();
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class, String.class, List.class);
                Command command = (Command)constructor.newInstance(name, description, usage, alias);
                command.setPermission(permission);
                command.setPermissionMessage(permissionMessage);
                commandList.add(command);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.error("Unable to register command " + clazz.getName() + "!");
                e.printStackTrace();
            }
        }
        CommandMap commandMap = BukkitReflectionUtil.getCommandMap();
        if (commandMap == null || commandList.isEmpty()) {
            return;
        }
        commandMap.registerAll(this.plugin.getDescription().getName(), commandList);
    }

    private void registerBasicCommands() {
        Set<Class<?>> annotatedWithRegisterCommand = this.getClassesAnnotatedWith(RegisterCommand.class);
        Set<Class<?>> annotatedWithTabComplete = this.getClassesAnnotatedWith(RegisterTabComplete.class);
        for (Class<?> clazz : annotatedWithRegisterCommand) {
            CommandExecutor commandExecutor;
            RegisterCommand commandAnnotation = clazz.getAnnotation(RegisterCommand.class);
            if (commandAnnotation == null) continue;
            String commandName = commandAnnotation.commandName();
            PluginCommand command = Bukkit.getServer().getPluginCommand(commandName);
            this.debugLog("Registering command: " + commandName + " from class " + clazz.getName());
            if (command == null) {
                throw new NotImplementedException("Missing plugin.yml registration for command: " + commandName);
            }
            try {
                commandExecutor = (CommandExecutor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                command.setExecutor(commandExecutor);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.plugin.getLogger().severe("Unable to register command: " + commandName + "!");
                e.printStackTrace();
                continue;
            }
            TabCompleter tabCompleter = this.getTabCompleterForCommand(annotatedWithTabComplete, commandName);
            if (tabCompleter != null) {
                command.setTabCompleter(tabCompleter);
            }
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (field.getAnnotation(InjectPlugin.class) == null) continue;
                    field.set(commandExecutor, this.plugin);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
            }
        }
    }

    private TabCompleter getTabCompleterForCommand(Set<Class<?>> annotatedWithTabComplete, String command) {
        try {
            for (Class<?> clazz : annotatedWithTabComplete) {
                RegisterTabComplete registerTabComplete = clazz.getAnnotation(RegisterTabComplete.class);
                if (registerTabComplete == null || !registerTabComplete.commandName().equals(command)) continue;
                return (TabCompleter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Set<Class<?>> getListeners() {
        Set<Class<?>> listeners = this.classes.stream().filter(Listener.class::isAssignableFrom).collect(Collectors.toSet());
        this.debugLog("Found: " + listeners.size() + " listeners.");
        return listeners;
    }
}

