/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.autoregister.util;

import com.miketheshadow.autoregister.annotations.InjectPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.bukkit.plugin.Plugin;

public class ReflectionBase {
    protected String packageName;
    protected Set<Class<?>> classes;
    protected Plugin plugin;
    protected boolean force = false;
    protected boolean debugLogging = false;
    protected boolean initialPackageFound = false;

    protected Set<Class<?>> collectAllClasses() {
        String searchName = this.packageName.replaceAll("[.]", "/");
        ClassLoader classLoader = this.plugin.getClass().getClassLoader();
        HashSet classes = new HashSet();
        try {
            ZipEntry entry;
            File currentFile = new File(this.plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(currentFile));
            while ((entry = jarInputStream.getNextEntry()) != null) {
                Class<?> clazz;
                String name = entry.getName();
                if (!this.force) {
                    String compare;
                    if (name.length() >= searchName.length()) {
                        compare = name.substring(0, searchName.length() - 1);
                        this.initialPackageFound = true;
                    } else {
                        compare = name;
                    }
                    if (!searchName.contains(compare) && !this.initialPackageFound) break;
                }
                if (!name.contains(searchName) || !name.endsWith(".class")) continue;
                try {
                    clazz = classLoader.loadClass(name.replace(".class", "").replaceAll("/", "."));
                }
                catch (Exception e) {
                    continue;
                }
                try {
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        if (field.getAnnotation(InjectPlugin.class) == null) continue;
                        field.set(clazz, this.plugin);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
                classes.add(clazz);
            }
            return classes;
        }
        catch (Exception e) {
            this.debugLog("Error loading classes! Unable to recover.");
            e.printStackTrace();
            this.debugLog("Total classes loaded: " + classes.size());
            return classes;
        }
    }

    public <A extends Annotation> Set<Class<?>> getClassesAnnotatedWith(Class<A> annotation) {
        if (!annotation.isAnnotation()) {
            throw new IllegalStateException("Class " + annotation.getName() + " is not an annotation!");
        }
        Set<Class<?>> annotated = this.classes.stream().filter(clazz -> clazz.getAnnotation(annotation) != null).collect(Collectors.toSet());
        this.debugLog("Found: " + annotated.size() + " classes annotated with " + annotation.getName());
        return annotated;
    }

    public void debugLog(String message) {
        if (this.debugLogging) {
            this.plugin.getLogger().info(message);
        }
    }

    public void error(String message) {
        this.plugin.getLogger().severe(message);
    }

    public ReflectionBase forceLoadAllClasses() {
        this.force = true;
        return this;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }
}

