/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.autoregister;

import com.miketheshadow.autoregister.annotations.CommandLoader;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class AutoRegister {
    Plugin plugin;
    String packageName;
    Set<Class<?>> classes;
    boolean force = false;
    boolean debugLogging = false;
    private boolean initialPackageFound = false;

    public AutoRegister(Plugin plugin, String packageName) {
        this.plugin = plugin;
        this.packageName = packageName;
        this.classes = this.collectAllClasses();
    }

    public AutoRegister enableDebugMessages() {
        this.debugLogging = true;
        return this;
    }

    public AutoRegister forceLoadAllClasses() {
        this.force = true;
        return this;
    }

    public void defaultSetup() {
        try {
            this.debugLog("Registering listeners...");
            this.registerListeners();
            this.debugLog("Registering commands....");
            this.registerCommands();
            this.debugLog("Setup complete!");
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Unable to register events with message: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void registerListeners() throws Exception {
        Set<Class<?>> clazzes = this.getListeners();
        PluginManager manager = Bukkit.getServer().getPluginManager();
        for (Class<?> clazz : clazzes) {
            this.debugLog("Registering listener: " + clazz.getName());
            Listener listener = (Listener)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            manager.registerEvents(listener, this.plugin);
            try {
                Field field = clazz.getDeclaredField("plugin");
                field.setAccessible(true);
                field.set(listener, this.plugin);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {}
        }
    }

    public void registerCommands() throws Exception {
        Set<Class<?>> annotated = this.getClassesAnnotatedWith(CommandLoader.class);
        for (Class<?> clazz : annotated) {
            CommandLoader commandAnnotation = clazz.getAnnotation(CommandLoader.class);
            if (commandAnnotation == null) continue;
            String commandName = commandAnnotation.commandName();
            PluginCommand command = Bukkit.getServer().getPluginCommand(commandName);
            this.debugLog("Registering command: " + commandName + " from class " + clazz.getName());
            if (command == null) {
                throw new NotImplementedException("Missing plugin.yml registration for command: " + commandName);
            }
            command.setExecutor((CommandExecutor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }

    public <A extends Annotation> Set<Class<?>> getClassesAnnotatedWith(Class<A> annotation) {
        if (!annotation.isAnnotation()) {
            throw new IllegalStateException("Class " + annotation.getName() + " is not an annotation!");
        }
        Set<Class<?>> annotated = this.classes.stream().filter(clazz -> clazz.getAnnotation(annotation) != null).collect(Collectors.toSet());
        this.debugLog("Found: " + annotated.size() + " classes annotated with " + annotation.getName());
        return annotated;
    }

    public Set<Class<?>> getListeners() {
        Set<Class<?>> listeners = this.classes.stream().filter(Listener.class::isAssignableFrom).collect(Collectors.toSet());
        this.debugLog("Found: " + listeners.size());
        return listeners;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    private Set<Class<?>> collectAllClasses() {
        String searchName = this.packageName.replaceAll("[.]", "/");
        ClassLoader classLoader = this.plugin.getClass().getClassLoader();
        HashSet classes = new HashSet();
        try {
            ZipEntry entry;
            File currentFile = new File(this.plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(currentFile));
            while ((entry = jarInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                if (!this.force) {
                    String compare;
                    if (name.length() >= searchName.length()) {
                        compare = name.substring(0, searchName.length() - 1);
                        this.initialPackageFound = true;
                    } else {
                        compare = name;
                    }
                    if (!searchName.contains(compare) && !this.initialPackageFound) break;
                }
                if (!name.contains(searchName) || !name.endsWith(".class")) continue;
                classes.add(classLoader.loadClass(name.replace(".class", "").replaceAll("/", ".")));
            }
            return classes;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debugLog("Total classes loaded: " + classes.size());
            return classes;
        }
    }

    private void debugLog(String message) {
        if (this.debugLogging) {
            Bukkit.getLogger().info(message);
        }
    }
}

