package com.miketheshadow.autoregister.annotations;

import org.jetbrains.annotations.NotNull;

import java.lang.annotation.*;

/**
 * Annotation targeting command Types.
 * Set the {@link CommandLoader#commandName()} argument to the command name
 * IE: if the command is /help -> @CommandLoader(commandName = "help").
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface CommandLoader {

    /**
     * This is a required field.
     * @return a string representing the commands name.
     */
    @NotNull
    String commandName();

}