/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.translib.api;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final HashMap<String, YamlConfiguration> configMap = new HashMap();

    public ConfigManager(@Nonnull File configFolder, @Nonnull String baseConfigName) {
        File[] files = configFolder.listFiles();
        if (files == null) {
            throw new IllegalStateException("Config folder " + configFolder.getAbsolutePath() + " is not a folder!");
        }
        YamlConfiguration primaryConfig = this.loadConfiguration(new File(configFolder, baseConfigName));
        for (File file : files) {
            YamlConfiguration yamlConfiguration = this.loadConfiguration(file);
            this.validateConfiguration(file, yamlConfiguration, primaryConfig);
            this.configMap.put(file.getName(), yamlConfiguration);
        }
    }

    public String getValue(String configName, String configValue) {
        YamlConfiguration configuration = this.configMap.get(configName);
        String value = configuration.getString(configValue);
        return value != null ? value : configName + "." + configValue;
    }

    private void validateConfiguration(File configFile, YamlConfiguration yamlConfiguration, YamlConfiguration primaryConfig) {
        Set keys = primaryConfig.getKeys(false);
        boolean isDirty = false;
        int missing = 0;
        for (String key : keys) {
            if (yamlConfiguration.contains(key)) continue;
            yamlConfiguration.set(key, (Object)primaryConfig.getString(key));
            yamlConfiguration.setComments(key, Collections.singletonList("Please update this field!"));
            isDirty = true;
            ++missing;
        }
        if (isDirty) {
            try {
                String message = "[TransLib] " + ChatColor.YELLOW + " Warning: config " + configFile.getAbsolutePath() + " is missing " + missing + " key(s). If you use this configuration please update it with the missing values. Otherwise ignore this message.";
                if (Bukkit.getServer() == null) {
                    Logger.getLogger(ConfigManager.class.getName()).warning(message);
                } else {
                    Bukkit.getServer().getLogger().warning(message);
                }
                yamlConfiguration.save(configFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to update config " + configFile.getAbsolutePath() + " " + e.getMessage());
            }
        }
    }

    private YamlConfiguration loadConfiguration(File file) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.load(file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load config! " + file.getAbsolutePath() + " " + e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalStateException("bad configuration file! " + file.getAbsolutePath() + " " + e.getMessage());
        }
        return yamlConfiguration;
    }

    @Deprecated
    public HashMap<String, YamlConfiguration> getConfigMap() {
        return this.configMap;
    }
}

