/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.translib;

import com.miketheshadow.translib.api.ConfigManager;
import java.io.File;
import javax.annotation.Nonnull;

public class TransLib {
    private final ConfigManager configManager;
    private String activeConfig;

    public TransLib(@Nonnull String baseConfigName, @Nonnull File configFolder, @Nonnull String activeConfig) {
        if (!configFolder.isDirectory()) {
            throw new IllegalStateException(configFolder.getAbsolutePath() + " is not a folder!");
        }
        this.configManager = new ConfigManager(configFolder, baseConfigName);
        this.activeConfig = activeConfig;
    }

    public TransLib(@Nonnull String baseConfigName, @Nonnull File configFolder) {
        if (!configFolder.isDirectory()) {
            throw new IllegalStateException(configFolder.getAbsolutePath() + " is not a folder!");
        }
        this.configManager = new ConfigManager(configFolder, baseConfigName);
        this.activeConfig = baseConfigName;
    }

    public TransLib(@Nonnull ConfigManager manager, @Nonnull String activeConfig) {
        this.configManager = manager;
        this.activeConfig = activeConfig;
    }

    public String getTranslation(String key) {
        return this.configManager.getValue(this.activeConfig, key);
    }

    public String getActiveConfig() {
        return this.activeConfig;
    }

    public void setActiveConfig(String activeConfig) {
        this.activeConfig = activeConfig;
    }

    public String getTranslationFromConfig(String config, String key) {
        return this.configManager.getValue(config, key);
    }
}

