/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.magmalink.listeners;

import com.miketheshadow.magmalink.MagmaLink;
import com.miketheshadow.magmalink.events.CustomGUICloseEvent;
import com.miketheshadow.magmalink.events.CustomGUIOpenEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class PlayerInventoryListener
implements Listener {
    Logger logger = MagmaLink.getStaticLogger();
    private static final HashMap<Location, Validated> activeLocationHashmap = new HashMap();
    private static final Set<UUID> coolDowns = new HashSet<UUID>();
    private final Plugin plugin;

    public PlayerInventoryListener(Plugin plugin) {
        this.plugin = plugin;
        Bukkit.getMessenger().registerIncomingPluginChannel(plugin, "cmmo:open_gui", (channel, player, message) -> PlayerInventoryListener.setValidated(player.getUniqueId()));
        Bukkit.getMessenger().registerIncomingPluginChannel(plugin, "cmmo:close_gui", (channel, player, message) -> PlayerInventoryListener.removeValidated(player.getUniqueId()));
    }

    @EventHandler
    public void blockRightClickEvent(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (block != null && event.getAction() == Action.RIGHT_CLICK_BLOCK && block.getBlockData().getAsString().toLowerCase().contains("cmmo:")) {
            String guiName = block.getBlockData().getAsString();
            Location location = block.getLocation();
            if (activeLocationHashmap.containsKey(location)) {
                event.setCancelled(true);
                player.sendMessage(ChatColor.RED + "Someone is already using this!");
            } else if (coolDowns.contains(player.getUniqueId())) {
                player.sendMessage(ChatColor.RED + "Please do not spam GUIs!");
                event.setCancelled(true);
            } else {
                coolDowns.add(player.getUniqueId());
                activeLocationHashmap.put(location, new Validated(player.getUniqueId(), false));
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
                    if (this.validateInventoryOpenEvent(location)) {
                        CustomGUIOpenEvent customGUIOpenEvent = new CustomGUIOpenEvent(player, guiName);
                        Bukkit.getPluginManager().callEvent((Event)customGUIOpenEvent);
                    }
                    coolDowns.remove(player.getUniqueId());
                }, 20L);
            }
        }
    }

    private boolean validateInventoryOpenEvent(Location location) {
        boolean value = PlayerInventoryListener.activeLocationHashmap.getOrDefault((Object)location, (Validated)new Validated((UUID)UUID.randomUUID(), (boolean)false)).validated;
        if (!value) {
            activeLocationHashmap.remove(location);
        }
        return value;
    }

    private static void setValidated(UUID uuid) {
        for (Map.Entry<Location, Validated> set : activeLocationHashmap.entrySet()) {
            Validated validated = set.getValue();
            if (!validated.uuid.equals(uuid)) continue;
            validated.validated = true;
            return;
        }
    }

    private static void removeValidated(UUID uuid) {
        for (Map.Entry<Location, Validated> set : activeLocationHashmap.entrySet()) {
            Validated validated = set.getValue();
            if (!validated.uuid.equals(uuid)) continue;
            activeLocationHashmap.remove(set.getKey());
            Bukkit.getPluginManager().callEvent((Event)new CustomGUICloseEvent(uuid));
            return;
        }
    }

    private static class Validated {
        public boolean validated;
        public UUID uuid;

        public Validated(UUID uuid, boolean validated) {
            this.validated = validated;
            this.uuid = uuid;
        }
    }
}

