/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.mmotextapi.itembuilder;

import com.miketheshadow.mmotextapi.itembuilder.ItemBuilder;
import com.miketheshadow.mmotextapi.text.Grade;
import com.miketheshadow.mmotextapi.text.ItemStat;
import com.miketheshadow.mmotextapi.utils.ColorConstants;
import com.miketheshadow.mmotextapi.utils.GearScoreFromStats;
import com.miketheshadow.mmotextapi.utils.Pair;
import java.util.Collections;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ToolItemBuilder
extends ItemBuilder {
    HashMap<ItemStat, Integer> playerStats;
    @Nullable
    Player crafter;

    public ToolItemBuilder(Plugin plugin, Material material, String name, @Nullable Player creator, HashMap<ItemStat, Integer> playerStats, HashMap<ItemStat, Integer> baseStats) {
        super(plugin, material, name);
        this.playerStats = playerStats;
        this.crafter = creator;
        this.addStatMap(baseStats);
    }

    public HashMap<ItemStat, Integer> getPlayerStats() {
        return this.playerStats;
    }

    public void setPlayerStats(HashMap<ItemStat, Integer> playerStats) {
        this.playerStats = playerStats;
    }

    @Override
    public ItemStack build() {
        Grade finalGrade;
        int durability;
        this.addTextToLore(this.getItemType());
        this.addTextToLore(this.grade.getColorCode() + this.grade.getReadableName());
        this.addTextToLore("");
        for (ItemStat stat : ItemStat.values()) {
            int result = this.playerStats.getOrDefault((Object)stat, 0);
            if (result <= 0) continue;
            this.persistentDataContainer.set(stat.getNameSpacedKey(this.plugin), PersistentDataType.INTEGER, result);
        }
        for (Pair stat : this.statPairs) {
            this.playerStats.put((ItemStat)((Object)stat.getKey()), stat.getValue());
        }
        int score = GearScoreFromStats.gearScoreFromMap(this.playerStats);
        String scoreText = "" + ColorConstants.NUMBER_CONSTANT + score;
        int attackDamage = this.playerStats.getOrDefault((Object)ItemStat.HANDLING, 0);
        if (attackDamage > 0) {
            this.addTextToLore("Damage ", "" + ColorConstants.NUMBER_CONSTANT + attackDamage);
            this.addTextToLore("");
        }
        if ((durability = this.playerStats.getOrDefault((Object)ItemStat.DURABILITY, 0).intValue()) > 0) {
            this.addTextToLore("[", "" + ColorConstants.NUMBER_CONSTANT + durability, "/", "" + ColorConstants.NUMBER_CONSTANT + durability, "]");
            this.addTextToLore("");
        }
        if (score > 0) {
            this.addTextToLore("GS: ", scoreText);
            this.addTextToLore("");
        }
        if (this.grade != (finalGrade = Grade.values()[Grade.values().length - 1])) {
            this.addTextToLore(ColorConstants.NUMBER_CONSTANT + "Upgradable");
            this.addTextToLore("");
        }
        if (!this.statPairs.isEmpty()) {
            Collections.sort(this.statPairs);
            for (Pair stat : this.statPairs) {
                this.addTextToLore(ColorConstants.BONUS_STAT_GREEN + ((ItemStat)((Object)stat.getKey())).getReadableName() + ": " + stat.getValue());
            }
            this.addTextToLore("");
        }
        if (this.description != null) {
            this.addFormattedParagraph(this.description);
        }
        if (this.crafter != null) {
            String name = this.crafter.getName();
            this.addTextToLore("Crafter: ", ColorConstants.NUMBER_CONSTANT + name);
        }
        this.meta.setLore(this.lore);
        this.meta.setDisplayName(this.grade.getColorCode() + this.name);
        this.stack.setItemMeta(this.meta);
        return this.stack;
    }
}

