/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.mmotextapi.itembuilder;

import com.miketheshadow.mmotextapi.itembuilder.FoodItemBuilder;
import com.miketheshadow.mmotextapi.itembuilder.IItemType;
import com.miketheshadow.mmotextapi.text.Grade;
import com.miketheshadow.mmotextapi.text.ItemStat;
import com.miketheshadow.mmotextapi.utils.ColorConstants;
import com.miketheshadow.mmotextapi.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder
implements IItemType {
    private final ItemStack stack;
    private final List<String> lore = new ArrayList<String>();
    @NotNull
    private final ItemMeta meta;
    private final String name;
    private Grade grade = Grade.BASIC;
    private String description;
    private final List<Pair<ItemStat>> statPairs = new ArrayList<Pair<ItemStat>>();
    private final PersistentDataContainer persistentDataContainer;
    private final Plugin plugin;

    public ItemBuilder(Plugin plugin, Material material, String name) {
        this.stack = new ItemStack(material, 1);
        this.meta = Objects.requireNonNull(this.stack.getItemMeta());
        this.name = name;
        this.plugin = plugin;
        if (this.meta == null) {
            throw new RuntimeException("Unable to find meta for " + material);
        }
        this.persistentDataContainer = this.meta.getPersistentDataContainer();
        this.setGrade(Grade.BASIC);
    }

    public ItemBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ItemBuilder setDescription(ChatColor color, String description) {
        this.description = color + description;
        this.persistentDataContainer.set(new NamespacedKey(this.plugin, "description"), PersistentDataType.STRING, description);
        return this;
    }

    public ItemBuilder addStat(ItemStat itemStat, int value) {
        this.statPairs.add(new Pair<ItemStat>(itemStat, value));
        this.persistentDataContainer.set(new NamespacedKey(this.plugin, itemStat.name()), PersistentDataType.INTEGER, value);
        return this;
    }

    public ItemBuilder addStatMap(HashMap<ItemStat, Integer> stats) {
        stats.forEach((stat, amount) -> {
            this.statPairs.add(new Pair<ItemStat>((ItemStat)((Object)stat), (Integer)amount));
            this.persistentDataContainer.set(new NamespacedKey(this.plugin, stat.name()), PersistentDataType.INTEGER, amount);
        });
        return this;
    }

    public ItemBuilder setGrade(Grade newGrade) {
        this.grade = newGrade;
        this.persistentDataContainer.set(new NamespacedKey(this.plugin, "grade"), PersistentDataType.STRING, newGrade.name());
        return this;
    }

    public ItemStack build() {
        this.addTextToLore(this.getItemType());
        this.addTextToLore(this.grade.getColorCode() + this.grade.getReadableName());
        this.addTextToLore("");
        ItemBuilder itemBuilder = this;
        if (itemBuilder instanceof FoodItemBuilder) {
            FoodItemBuilder foodItemBuilder = (FoodItemBuilder)itemBuilder;
            if (foodItemBuilder.getItemType().equalsIgnoreCase("Ingredient")) {
                this.addTextToLore("This is a rank ", foodItemBuilder.getRank(), " ingredient.");
                this.addTextToLore("");
            } else {
                this.addTextToLore("This is a rank ", foodItemBuilder.getRank(), " food item.");
                this.addTextToLore("");
                this.addTextToLore("Cast Time: ", foodItemBuilder.getCastTime());
                this.addTextToLore("Cooldown: ", foodItemBuilder.getCoolDown());
                this.addTextToLore("");
                this.addTextToLore("A food item that lasts ", foodItemBuilder.getDuration());
                this.addTextToLore("and gives the effects below");
                this.addTextToLore("");
            }
        }
        if (!this.statPairs.isEmpty()) {
            Collections.sort(this.statPairs);
            for (Pair<ItemStat> stat : this.statPairs) {
                this.addTextToLore(ColorConstants.BONUS_STAT_GREEN + stat.getKey().getReadableName() + ": " + stat.getValue());
            }
            this.addTextToLore("");
        }
        if (this.description != null) {
            this.addFormattedParagraph(this.description);
        }
        this.meta.setLore(this.lore);
        this.meta.setDisplayName(this.grade.getColorCode() + this.name);
        this.stack.setItemMeta(this.meta);
        return this.stack;
    }

    private void addFormattedParagraph(String paragraph) {
        String[] strings;
        StringBuilder builder = new StringBuilder();
        for (String string : strings = paragraph.split(" ")) {
            builder.append(string).append(" ");
            if (builder.length() <= 30) continue;
            this.lore.add("" + ChatColor.RESET + ChatColor.WHITE + builder);
            builder = new StringBuilder();
        }
        if (builder.length() > 0) {
            this.lore.add("" + ChatColor.RESET + ChatColor.WHITE + builder);
        }
    }

    private void addTextToLore(String ... texts) {
        if (texts[0].equals("")) {
            this.lore.add("");
            return;
        }
        StringBuilder quickBuilder = new StringBuilder();
        for (String text : texts) {
            quickBuilder.append(ChatColor.RESET).append(ChatColor.WHITE).append(text);
        }
        this.lore.add(quickBuilder.toString());
    }

    @Override
    public String getItemType() {
        return "Item";
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }
}

