/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.utils;

import java.text.DecimalFormat;

public class TextFormatter {
    public static String formatNumber(String number) {
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat.format(number);
    }

    public static String formatNumber(double number) {
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat.format(number);
    }

    private static String removeZeros(double d) {
        DecimalFormat df = new DecimalFormat("0.##");
        return df.format(d);
    }

    public static String commaFlatNumber(double number) {
        DecimalFormat formatter = new DecimalFormat("#,##0");
        return formatter.format(number);
    }

    public static String numberToString(double num) {
        if (num < 1000000.0) {
            return TextFormatter.formatNumber(Math.round(num));
        }
        if (num < 1.0E9) {
            return TextFormatter.removeZeros(num / 1000000.0) + "M";
        }
        if (num < 1.0E12) {
            return TextFormatter.removeZeros(num / 1.0E9) + "B";
        }
        return TextFormatter.removeZeros(num / 1.0E12) + "T";
    }

    public static String numberToString(String numString) {
        double num = Double.parseDouble(numString);
        return TextFormatter.numberToString(num);
    }

    public static String commaNumber(double number) {
        DecimalFormat formatter = new DecimalFormat("#,##0.#");
        return formatter.format(number);
    }

    public static String commaNumberNoZeros(double number) {
        DecimalFormat formatter = new DecimalFormat("#,###");
        return formatter.format(number);
    }

    public static String formatPrice(double number) {
        DecimalFormat formatter = new DecimalFormat("#,##0.00######");
        for (int i = 1; i < 18; ++i) {
            if (!(number * Math.pow(10.0, i) > 1.0)) continue;
            formatter.setMaximumFractionDigits(i + 3);
            break;
        }
        formatter.setMinimumFractionDigits(2);
        return formatter.format(number);
    }

    public static String formatPriceExperimental(double value) {
        String valueString = Double.toString(value);
        int increase = 4;
        if (valueString.startsWith("0.")) {
            valueString = valueString.replace("0.", "");
            for (char item : valueString.toCharArray()) {
                if (item != '0') break;
                ++increase;
            }
            if (increase > valueString.length()) {
                increase = valueString.length();
            }
            double commaValue = Double.parseDouble("0." + valueString.substring(0, increase));
            return "$" + TextFormatter.formatPrice(commaValue);
        }
        return "$" + TextFormatter.formatPrice(value);
    }
}

