package com.miketheshadow.cryptolib.utils;

import com.google.common.base.Splitter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

import static com.miketheshadow.cryptolib.utils.Constants.PADDING;

public class HexConverter {

    public static long hexToLong(String val) {
        return new BigInteger(val.replace("0x", ""), 16).longValue();
    }

    public static String numToHex(long val) {
        return "0x" + Long.toHexString(val);
    }
    public static String numToHex(double val) {
        BigInteger bigDecimal = new BigDecimal(val).toBigInteger();
        return "0x" + bigDecimal.toString(16);
    }

    public static double hexToDouble(String val) {
        return new BigInteger(val.replace("0x", ""), 16).doubleValue();
    }

    public static double hexToDoubleDividedByPower(String val, int power) {
        double rawValue = new BigInteger(val.replace("0x", ""), 16).doubleValue();
        if(rawValue == 0d) return rawValue;
        return rawValue / Math.pow(10, power);
    }

    public static List<String> hexToMultiLineArgs(String value) {

        Splitter splitter = Splitter.fixedLength(64);
        return splitter.splitToList(value.replace("0x",""));
    }

    public static String hexToAddress(String value) {
        return value.replace(PADDING, "");
    }
}
