/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.request.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RequestBuilder.class);
    ObjectMapper mapper = new ObjectMapper();
    ObjectNode node = this.mapper.createObjectNode();

    public static RequestBuilder createWithMethod(String method) {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.node.put("id", 1);
        requestBuilder.node.put("method", method);
        return requestBuilder;
    }

    public RequestBuilder setId(int id) {
        this.node.put("id", id);
        return this;
    }

    public void setParams(ArrayNode params) {
        this.node.put("params", params);
    }

    public void setParams(HashMap<String, String> params) {
        ArrayNode arrayNode = this.mapper.createArrayNode();
        ObjectNode objectNode = this.mapper.createObjectNode();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            objectNode.put(entry.getKey(), entry.getValue());
        }
        arrayNode.add(objectNode);
        arrayNode.add("latest");
        this.node.put("params", arrayNode);
    }

    public String toString() {
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.node);
        }
        catch (JsonProcessingException e) {
            logger.error("Error building request: " + e.getMessage());
            return "";
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

