/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.request.bulkrequest;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.request.IRequestError;
import com.miketheshadow.cryptolib.request.RequestException;
import com.miketheshadow.cryptolib.request.bulkrequest.Requestable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkRequest<T> {
    Logger logger = LoggerFactory.getLogger(BulkRequest.class);
    private final List<? extends Requestable> requestables;
    private final Class<?> mapping;
    private final String nodeString;
    private final boolean retryOnError;
    private int delay = 0;
    private int errorDelay = 0;
    private boolean debug = false;
    private int increaseBy = 100;

    public BulkRequest(CryptoLib lib, List<? extends Requestable> requestables, Class<?> mapping, boolean retryOnError) {
        this.nodeString = lib.getNodeString();
        this.requestables = requestables;
        this.mapping = mapping;
        this.retryOnError = retryOnError;
    }

    public BulkRequest(String nodeString, List<? extends Requestable> requestables, Class<?> mapping, boolean retryOnError) {
        this.nodeString = nodeString;
        this.requestables = requestables;
        this.mapping = mapping;
        this.retryOnError = retryOnError;
    }

    public void withDelay(int seconds) {
        this.delay = seconds;
    }

    public void withExtraDebug() {
        this.debug = true;
    }

    public void setDelayOnError(int delay) {
        this.errorDelay = delay;
    }

    public void setIncreaseBy(int amount) {
        this.increaseBy = amount;
    }

    public List<T> get() throws RequestException {
        ArrayList<T> result = new ArrayList<T>();
        double totalCompleted = 0.0;
        block6: for (String requestString : this.generateBulkRequests()) {
            while (true) {
                try {
                    List<T> values2;
                    block13: {
                        do {
                            MediaType mediaType = MediaType.parse("application/json");
                            RequestBody body = RequestBody.create(mediaType, requestString);
                            Request request = new Request.Builder().url(this.nodeString).method("POST", body).addHeader("Content-Type", "application/json").build();
                            values2 = this.executeRequest(request);
                            if (values2 == null) {
                                throw new RequestException("Unable to update Bulk Requests!");
                            }
                            if (this.debug) {
                                this.logger.info("adding " + values2.size() + " values " + (totalCompleted += (double)values2.size()) + "/" + this.requestables.size() + " " + totalCompleted / (double)this.requestables.size() * 100.0 + "%");
                            }
                            boolean error = false;
                            for (T req : values2) {
                                IRequestError requestError;
                                if (!(req instanceof IRequestError) || (requestError = (IRequestError)req).getError() == null || requestError.getError().message == null) continue;
                                this.logger.warn("generic request generated an error: " + requestError.getError().message + " retrying...");
                                error = true;
                            }
                            if (!error) break block13;
                        } while (this.errorDelay <= 0);
                        try {
                            Thread.sleep((long)this.errorDelay * 1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    result.addAll(values2);
                    continue block6;
                }
                catch (RequestException requestException) {
                    if (!this.retryOnError) {
                        throw new RequestException(requestException);
                    }
                    this.logger.warn("Bulk Request errored however retryOnError is true: " + requestException.getMessage());
                    if (this.delay <= 0) continue;
                    try {
                        Thread.sleep((long)this.delay * 1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return result;
    }

    private List<String> generateBulkRequests() {
        List<List<? extends Requestable>> requestLists = Lists.partition(this.requestables, this.increaseBy / this.requestables.get(0).requestSize());
        ArrayList<String> requestStrings = new ArrayList<String>();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (List<? extends Requestable> list : requestLists) {
            requestStrings.add(this.generateRequest(list, atomicInteger));
        }
        return requestStrings;
    }

    private String generateRequest(List<? extends Requestable> requests, AtomicInteger startIndex) {
        Joiner joiner = Joiner.on(",");
        return "[" + joiner.join(requests.stream().map(requestable -> requestable.getAsRequest(startIndex.getAndIncrement())).toList()) + "]";
    }

    private List<T> executeRequest(Request request) {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Response response = client.newCall(request).execute();
        try {
            String bodyString = response.body().string();
            ObjectMapper mapper = new ObjectMapper();
            JavaType type = BulkRequest.getCollectionType(mapper, List.class, this.mapping);
            List list = (List)mapper.readValue(bodyString, type);
            if (response != null) {
                response.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static JavaType getCollectionType(ObjectMapper mapper, Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }
}

