package com.miketheshadow.cryptolib.containers.transaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TransactionInfo {

    public String id;
    public String jsonrpc;
    public Result result;

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Log {
        public String address;
        public String blockHash;
        public String blockNumber;
        public String data;
        public String logIndex;
        public boolean removed;
        public ArrayList<String> topics;
        public String transactionHash;
        public String transactionIndex;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Result {
        public String blockHash;
        public String blockNumber;
        public Object contractAddress;
        public String cumulativeGasUsed;
        public String effectiveGasPrice;
        public String from;
        public String gasUsed;
        public ArrayList<Log> logs;
        public String logsBloom;
        public String status;
        @JsonProperty("to")
        public String myto;
        public String transactionHash;
        public String transactionIndex;
        public String type;
    }

}
