/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.price;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.miketheshadow.cryptolib.price.BinancePriceData;
import com.miketheshadow.cryptolib.request.RequestException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class BinancePriceFetcher {
    public static double getPrice(String url) throws RequestException {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(url).get().build();
            Response response = client.newCall(request).execute();
            ObjectMapper mapper = new ObjectMapper();
            BinancePriceData data = mapper.readValue(response.body().string(), BinancePriceData.class);
            return data.price;
        }
        catch (Exception e) {
            throw new RequestException("Error occurred while fetching price from binance : " + e.getMessage());
        }
    }
}

