/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.price;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.price.DexToolsPriceData;
import com.miketheshadow.cryptolib.request.RequestException;
import com.miketheshadow.cryptolib.utils.TextFormatter;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class PriceLib {
    boolean isDex = false;
    String dexToken;
    String dexUrl;
    CryptoLib lib;
    String exchange;
    String pairAddress;
    double cachedPrice;

    public PriceLib(CryptoLib lib, String exchange, String pairAddress) {
        this.lib = lib;
        this.exchange = exchange;
        this.pairAddress = pairAddress;
    }

    public PriceLib(String dexUrl, String dexToken) {
        this.isDex = true;
        this.dexUrl = dexUrl;
        this.dexToken = dexToken;
    }

    public double getNewPrice() throws RequestException {
        double price;
        if (this.isDex) {
            try {
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Request request = new Request.Builder().url("https://api.dexscreener.com/latest/dex/pairs/osmosis/2").get().build();
                Response response = client.newCall(request).execute();
                ObjectMapper mapper = new ObjectMapper();
                DexToolsPriceData data = mapper.readValue(response.body().string(), DexToolsPriceData.class);
                price = data.pair.priceUsd;
            }
            catch (Exception e) {
                throw new RequestException("Error occurred while fetching price: " + e.getMessage());
            }
        } else {
            double exchangeFirstBalance = this.lib.walletUtils.getBalance(this.exchange);
            int zeros = this.lib.contractUtils.getZerosForOtherToken(this.pairAddress);
            double exchangeSecondBalance = this.lib.walletUtils.getOtherTokenBalance(this.pairAddress, this.exchange, zeros);
            price = exchangeSecondBalance / exchangeFirstBalance;
        }
        this.cachedPrice = price;
        return price;
    }

    public double getCachedPrice() {
        return this.cachedPrice;
    }

    public String getNewPriceFormatted() throws RequestException {
        return TextFormatter.formatPriceExperimental(this.getNewPrice());
    }

    public String getCachedPriceFormatted() {
        return TextFormatter.formatPriceExperimental(this.cachedPrice);
    }
}

