package com.miketheshadow.cryptolib.utils;

import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.containers.GenericRequest;
import com.miketheshadow.cryptolib.request.RequestException;

public class WalletUtils {

    CryptoLib lib;

    public WalletUtils(CryptoLib lib) {
        this.lib = lib;
    }

    public double getBalance(String holder) throws RequestException {
        GenericRequest accountBalance = lib.requests.GENERIC_REQUEST.requestChainInfo("{\r\n  \"jsonrpc\": \"2.0\",\r\n  \"id\": 1,\r\n  \"method\": \"eth_call\",\r\n  \"params\": [\r\n    {\r\n      \"data\": \"0x70a08231000000000000000000000000"
                + holder.replace("0x", "")
                + "\",\r\n      \"to\": \"" + lib.getContract() + "\"\r\n    },\r\n    \"latest\"\r\n  ]\r\n}\r\n");
        return HexConverter.hexToDouble(accountBalance.result) / Math.pow(10, this.lib.getZeros());

    }

    public String getBalanceRaw(String holder) throws RequestException {
        GenericRequest accountBalance = lib.requests.GENERIC_REQUEST.requestChainInfo("{\r\n  \"jsonrpc\": \"2.0\",\r\n  \"id\": 1,\r\n  \"method\": \"eth_call\",\r\n  \"params\": [\r\n    {\r\n      \"data\": \"0x70a08231000000000000000000000000"
                + holder.replace("0x", "")
                + "\",\r\n      \"to\": \"" + lib.getContract() + "\"\r\n    },\r\n    \"latest\"\r\n  ]\r\n}\r\n");
        return accountBalance.result;
    }

    public double getBalance(String holder, long block) throws RequestException {
        if(!lib.hasArchiveNodeSupport()) throw new RequestException("Missing required archive node string in CryptoLib constructor!");
        GenericRequest accountBalance = lib.requests.GENERIC_REQUEST.requestChainInfo("{\r\n  \"jsonrpc\": \"2.0\",\r\n  \"id\": 1,\r\n  \"method\": \"eth_call\",\r\n  \"params\": [\r\n    {\r\n      \"data\": \"0x70a08231000000000000000000000000"
                + holder.replace("0x", "")
                + "\",\r\n      \"to\": \"" + lib.getContract() + "\"\r\n    },\r\n    \"" + HexConverter.numToHex(block) + "\"\r\n  ]\r\n}\r\n",lib.getArchiveNodeString());
        return HexConverter.hexToDouble(accountBalance.result) / Math.pow(10, this.lib.getZeros());
    }

    public double getBNBOfWallet(String wallet) throws RequestException {
        GenericRequest accountBalance = lib.requests.GENERIC_REQUEST.requestChainInfo("{\r\n    \"jsonrpc\": \"2.0\",\r\n    \"method\": \"eth_getBalance\",\r\n    \"params\": [\r\n        \"" + wallet + "\",\r\n        \"latest\"\r\n    ],\r\n    \"id\": 1\r\n}");
        return HexConverter.hexToDouble(accountBalance.result) / Math.pow(10, 18);
    }

    public double getWBNBOfWallet(String wallet) throws RequestException {
        return getOtherTokenBalance("0xbb4CdB9CBd36B01bD1cBaEBF2De08d9173bc095c",wallet,18);
    }

    public double getBUSDOfWallet(String wallet) throws RequestException {
        return getOtherTokenBalance("0xe9e7cea3dedca5984780bafc599bd69add087d56",wallet,18);
    }

    public double getOtherTokenBalance(String token, String wallet,int zeros) throws RequestException {
        GenericRequest accountBalance = lib.requests.GENERIC_REQUEST.requestChainInfo("{\r\n    \"jsonrpc\": \"2.0\",\r\n    \"method\": \"eth_call\",\r\n    \"params\": [\r\n        {\r\n            \"to\": \"" + token + "\",\r\n            \"data\": \"0x70a08231000000000000000000000000" + wallet.replace("0x", "") + "\"\r\n        },\r\n        \"latest\"\r\n    ],\r\n    \"id\": 67\r\n}");
        return HexConverter.hexToDouble(accountBalance.result) / Math.pow(10, zeros);
    }

    public boolean isContract(String address) throws RequestException {
        GenericRequest contract = lib.requests.GENERIC_REQUEST.requestChainInfo("{\"jsonrpc\":\"2.0\",\"method\":\"eth_getCode\",\"params\":[" +
                "\"" + address + "\", \"latest\"],\"id\":1}");
        if (contract == null) return false;
        return contract.result.length() > 2;
    }

}
