package com.miketheshadow.cryptolib.containers.transaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.utils.HexConverter;

import java.util.List;

import static com.miketheshadow.cryptolib.utils.Constants.PADDING;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ToFromTransactions {
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Transaction {
        public String address;
        public List<String> topics;
        public String data;
        public String blockNumber;
        public String transactionHash;
        public String transactionIndex;
        public String blockHash;
        public String logIndex;
        public boolean removed;

        public String getSender() {
            return "0x" + topics.get(1).replace(PADDING, "");
        }

        public String getReceiver() {
            return "0x" + topics.get(2).replace(PADDING, "");
        }

        public String getUniqueIdentifier() {
            return transactionHash + logIndex + transactionIndex;
        }

        public long getBlock() {
            return HexConverter.hexToLong(blockNumber);
        }

        public double getValue(CryptoLib lib) {
            return HexConverter.hexToDoubleDividedByPower(data,lib.getZeros());
        }
    }

    public String jsonrpc;
    public int id;
    public List<Transaction> result;

}
