/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.request.bulkrequest;

import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.request.bulkrequest.Requestable;
import com.miketheshadow.cryptolib.utils.HexConverter;

public class ArchiveBulkBalanceRequestable
implements Requestable {
    String address;
    CryptoLib lib;
    long block;

    public ArchiveBulkBalanceRequestable(String address, CryptoLib lib, long block) {
        this.address = address;
        this.lib = lib;
        this.block = block;
    }

    @Override
    public String getAsRequest(int id) {
        return "{\r\n  \"jsonrpc\": \"2.0\",\r\n  \"id\": " + id + ",\r\n  \"method\": \"eth_call\",\r\n  \"params\": [\r\n    {\r\n      \"data\": \"0x70a08231000000000000000000000000" + this.address.replace("0x", "") + "\",\r\n      \"to\": \"" + this.lib.getContract() + "\"\r\n    },\r\n    \"" + HexConverter.numToHex(this.block) + "\"\r\n  ]\r\n}\r\n";
    }

    @Override
    public int requestSize() {
        return 1;
    }

    public String getAddress() {
        return this.address;
    }
}

