package com.miketheshadow.cryptolib.request;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.containers.transaction.ToFromTransactions;
import com.miketheshadow.cryptolib.request.builder.RequestBuilder;
import com.miketheshadow.cryptolib.utils.HexConverter;

import javax.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PreBuiltRequests {

    public static List<ToFromTransactions.Transaction> blockToFromTransfers(CryptoLib lib, long from, long to) throws RequestException {
        return blockToFrom(lib, lib.getContract(),from,to, Collections.singletonList("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"));
    }

    public static List<ToFromTransactions.Transaction> blockToFrom(CryptoLib lib, long from, long to, List<String> topics) throws RequestException {
        return blockToFrom(lib, lib.getContract(),from,to,topics);
    }

    public static List<ToFromTransactions.Transaction> blockToFrom(CryptoLib lib,String contract, long from, long to) throws RequestException {
        return blockToFrom(lib,contract,from,to,null);
    }

    public static List<ToFromTransactions.Transaction> blockToFrom(CryptoLib lib, String contract, long from, long to, @Nullable List<String> topics) throws RequestException {
        RequestBuilder builder = RequestBuilder.createWithMethod("eth_getLogs");
        ArrayNode params = builder.getMapper().createArrayNode();
        ObjectNode node = builder.getMapper().createObjectNode();
        node.put("address",contract);
        if(topics != null) {
            ArrayNode arrayTopics = builder.getMapper().createArrayNode();
            for(String topic : topics) arrayTopics.add(topic);
            node.put("topics",arrayTopics);
        }
        node.put("fromBlock", HexConverter.numToHex(from));
        node.put("toBlock", HexConverter.numToHex(to));
        params.add(node);
        builder.setParams(params);
        return lib.requests.TO_FROM_TRANSACTIONS_REQUEST.requestChainInfo(builder.toString()).result;
    }

    public static String ethCall(String to, String data) {
        RequestBuilder builder = RequestBuilder.createWithMethod("eth_call");
        HashMap<String,String> args = new HashMap<>();
        args.put("data",data);
        args.put("to",to);
        builder.setParams(args);
        return builder.toString();
    }

    public static String ethCall(String to, String data,int id) {
        RequestBuilder builder = RequestBuilder.createWithMethod("eth_call");
        builder.setId(id);
        HashMap<String,String> args = new HashMap<>();
        args.put("data",data);
        args.put("to",to);
        builder.setParams(args);
        return builder.toString();
    }
}
