package com.miketheshadow.cryptolib.binance;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.miketheshadow.cryptolib.request.RequestException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;

public class BinancePrice {

    public static double getBinancePrice(String url) throws RequestException {
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        Request request = new Request.Builder()
                .url(url)
                .method("GET", null)
                .build();
        try {
            Response response = client.newCall(request).execute();
            double BNBPrice = (new ObjectMapper()).readValue(response.body().string(), BinancePrice.BNBPrice.class).price;
            response.close();
            return BNBPrice;
        } catch (IOException e) {
            throw new RequestException(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    private static class BNBPrice {
        public String symbol;
        public double price;
    }
}