package com.miketheshadow.cryptolib.containers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.miketheshadow.cryptolib.request.RequestException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;

public class BinancePrice {

    public static double getBinancePrice() throws RequestException {
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        Request request = new Request.Builder()
                .url("https://api.binance.com/api/v3/ticker/price?symbol=BNBUSDT")
                .method("GET", null)
                .build();
        try {
            Response response = client.newCall(request).execute();
            double BNBPrice = (new ObjectMapper()).readValue(response.body().string(), BinancePrice.BNBPrice.class).price;
            response.close();
            return BNBPrice;
        } catch (IOException e) {
            throw new RequestException("unable to get binance price: " + e.getMessage());
        }
    }

    private static class BNBPrice {
        public String symbol;
        public double price;
    }
}
