/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.utils;

import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.containers.GenericRequest;
import com.miketheshadow.cryptolib.request.RequestException;
import com.miketheshadow.cryptolib.utils.HexConverter;
import java.lang.invoke.StringConcatFactory;

public class ContractUtils {
    CryptoLib lib;

    public ContractUtils(CryptoLib lib) {
        this.lib = lib;
    }

    public double getBurnedSupply(double baseSupply) throws RequestException {
        double burn = this.lib.walletUtils.getBalance(this.lib.getDeadAddress());
        return baseSupply - burn;
    }

    public double getTotalSupply() throws RequestException {
        GenericRequest request = this.lib.requests.GENERIC_REQUEST.requestChainInfo("{\r\n  \"jsonrpc\": \"2.0\",\r\n  \"id\": 1,\r\n  \"method\": \"eth_call\",\r\n  \"params\": [\r\n    {\r\n      \"to\": \"" + this.lib.getContract() + "\",\r\n      \"data\" : \"0x18160ddd\"\r\n    },\r\n    \"latest\"\r\n  ]\r\n}");
        return HexConverter.hexToDouble(request.result) / Math.pow(10.0, this.lib.getZeros());
    }

    public double getTotalSupplyForToken(String token) throws RequestException {
        GenericRequest request = this.lib.requests.GENERIC_REQUEST.requestChainInfo("{\r\n  \"jsonrpc\": \"2.0\",\r\n  \"id\": 1,\r\n  \"method\": \"eth_call\",\r\n  \"params\": [\r\n    {\r\n      \"to\": \"" + token + "\",\r\n      \"data\" : \"0x18160ddd\"\r\n    },\r\n    \"latest\"\r\n  ]\r\n}");
        return HexConverter.hexToDouble(request.result) / Math.pow(10.0, this.lib.getZeros());
    }

    public double getBurn() throws RequestException {
        return this.lib.walletUtils.getBalance(this.lib.getDeadAddress());
    }

    public long getLastRebaseTime() throws RequestException {
        GenericRequest request = this.lib.requests.GENERIC_REQUEST.requestChainInfo("{\"jsonrpc\":\"2.0\",\"method\":\"eth_call\",\"params\":[{\"data\":\"0x32b75683\",\"to\":\"0x69104fb28f4bb9f6efc899bd1d94f386cdf1b9da\"},\"latest\"],\"id\":1}");
        return HexConverter.hexToLong(request.result);
    }

    public int getZeros() throws RequestException {
        return (int)HexConverter.hexToLong(this.lib.requests.GENERIC_REQUEST.requestChainInfo((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"{\"jsonrpc\":\"2.0\",\"method\":\"eth_call\",\"params\":[{\"data\":\"0x313ce567\",\"to\":\"\u0001\"},\"latest\"],\"id\":1}"}, (String)this.lib.getContract()))).result);
    }
}

