/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.request.RequestException;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record BlockChainRequest<T>(Class<T> type, CryptoLib lib) {
    private static final Logger logger = LoggerFactory.getLogger(BlockChainRequest.class);

    public T requestChainInfo(String data) throws RequestException {
        return this.requestChainInfo(data, this.lib.getNodeString());
    }

    public T requestChainInfo(String data, String node) throws RequestException {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(mediaType, data);
        Request request = new Request.Builder().url(node).method("POST", body).addHeader("Content-Type", "application/json").build();
        try {
            String bodyString;
            try (Response response = client.newCall(request).execute();){
                bodyString = response.body().string();
            }
            catch (IOException e) {
                throw new RequestException(e);
            }
            return new ObjectMapper().readValue(bodyString, this.type);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Bad request: " + e.getMessage() + " | " + this.lib.getNodeString() + " | " + this.type.getName());
        }
    }
}

