package com.miketheshadow.cryptolib.utils;

import java.text.DecimalFormat;

/**
 * For formatting text so it looks pretty to your average user
 */
public class TextFormatter {


    public static String formatNumber(String number) {
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);

        return decimalFormat.format(number);
    }

    public static String formatNumber(double number) {
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat.format(number);
    }

    private static String removeZeros(double d) {
        DecimalFormat df = new DecimalFormat("0.##");
        return df.format(d);
    }

    public static String commaFlatNumber(double number) {
        DecimalFormat formatter = new DecimalFormat("#,###");
        return formatter.format(number);
    }

    public static String numberToString(double num) {
        if (num < 1000000d) {
            return formatNumber(Math.round(num));
        } else if (num < 1000000000d) {
            return removeZeros(num / 1000000d) + "M";
        } else if (num < 1000000000000d) {
            return removeZeros(num / 1000000000d) + "B";
        } else {
            return removeZeros(num / 1000000000000d) + "T";
        }
    }

    public static String numberToString(String numString) {
        double num = Double.parseDouble(numString);
        return numberToString(num);


    }

    public static String commaNumber(double number) {
        DecimalFormat formatter = new DecimalFormat("#,###.0");
        return formatter.format(number);
    }

    public static String commaNumberNoZeros(double number) {
        DecimalFormat formatter = new DecimalFormat("#,###");
        return formatter.format(number);
    }

    public static String formatPrice(double number) {
        DecimalFormat formatter = new DecimalFormat("#,###.00000000");
        formatter.setMinimumIntegerDigits(0);
        return formatter.format(number);
    }
}
