package com.miketheshadow.cryptolib.utils;

import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.containers.LatestBlockContainer;
import com.miketheshadow.cryptolib.request.RequestException;

public class BlockUtils {

    CryptoLib lib;

    public BlockUtils(CryptoLib lib) {
        this.lib = lib;
    }

    public Long getLatestBlock() throws RequestException {
        LatestBlockContainer container = lib.requests.BLOCK_INFO_REQUEST.requestChainInfo("{\"jsonrpc\":\"2.0\",\"method\":\"eth_getBlockByNumber\",\"params\":[\"latest\", false],\"id\":1}");
        return HexConverter.hexToLong(container.result.number);
    }

}
