/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.containers.LatestBlockContainer;
import com.miketheshadow.cryptolib.containers.QuickLogContainer;
import com.miketheshadow.cryptolib.request.RequestException;
import com.miketheshadow.cryptolib.utils.HexConverter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class BlockUtils {
    CryptoLib lib;

    public BlockUtils(CryptoLib lib) {
        this.lib = lib;
    }

    public Long getLatestBlock() throws RequestException {
        LatestBlockContainer container = this.lib.requests.BLOCK_INFO_REQUEST.requestChainInfo("{\"jsonrpc\":\"2.0\",\"method\":\"eth_getBlockByNumber\",\"params\":[\"latest\", false],\"id\":1}");
        return HexConverter.hexToLong(container.result.number);
    }

    public boolean isBurnTransaction(String hash) {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(mediaType, "{\r\n    \"jsonrpc\": \"2.0\",\r\n    \"method\": \"eth_getTransactionReceipt\",\r\n    \"params\": [\r\n        \"" + hash + "\"\r\n    ],\r\n    \"id\": 1\r\n}");
        Request request = new Request.Builder().url(this.lib.getNodeString()).method("POST", body).addHeader("Content-Type", "application/json").build();
        try {
            QuickLogContainer container;
            try (Response response = client.newCall(request).execute();){
                container = new ObjectMapper().readValue(response.body().string(), QuickLogContainer.class);
            }
            for (QuickLogContainer.Log log : container.result.logs) {
                if (!log.topics.get(0).equalsIgnoreCase("0xdccd412f0b1252819cb1fd330b93224ca42612892bb3f4f789976e6d81936496")) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

