/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.request.builder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.request.builder.RequestBuilder;
import com.miketheshadow.cryptolib.utils.HexConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

public class PreBuiltRequests {
    public static String blockToFromTransfers(CryptoLib lib, long from, long to) {
        return PreBuiltRequests.blockToFrom(lib.getContract(), from, to, Collections.singletonList("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"));
    }

    public static String blockToFrom(CryptoLib lib, long from, long to, List<String> topics) {
        return PreBuiltRequests.blockToFrom(lib.getContract(), from, to, topics);
    }

    public static String blockToFrom(String contract, long from, long to) {
        return PreBuiltRequests.blockToFrom(contract, from, to, null);
    }

    public static String blockToFrom(CryptoLib lib, long from, long to) {
        return PreBuiltRequests.blockToFrom(lib.getContract(), from, to, null);
    }

    public static String blockToFrom(String contract, long from, long to, @Nullable List<String> topics) {
        RequestBuilder builder = RequestBuilder.createWithMethod("eth_getLogs");
        ArrayNode params = builder.getMapper().createArrayNode();
        ObjectNode node = builder.getMapper().createObjectNode();
        node.put("address", contract);
        if (topics != null) {
            ArrayNode arrayTopics = builder.getMapper().createArrayNode();
            for (String topic : topics) {
                arrayTopics.add(topic);
            }
            node.put("topics", arrayTopics);
        }
        node.put("fromBlock", HexConverter.numToHex(from));
        node.put("toBlock", HexConverter.numToHex(to));
        params.add(node);
        builder.setParams(params);
        return builder.toString();
    }

    public static String ethCall(String to, String data) {
        RequestBuilder builder = RequestBuilder.createWithMethod("eth_call");
        HashMap<String, String> args2 = new HashMap<String, String>();
        args2.put("data", data);
        args2.put("to", to);
        builder.setParams(args2);
        return builder.toString();
    }
}

