package com.miketheshadow.cryptolib.request.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class RequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RequestBuilder.class);
    ObjectMapper mapper = new ObjectMapper();
    ObjectNode node = mapper.createObjectNode();
    public static RequestBuilder createWithMethod(String method) {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.node.put("id", 1);
        requestBuilder.node.put("method", method);
        return requestBuilder;
    }

    public RequestBuilder setId(int id) {
        node.put("id",id);
        return this;
    }

    public void setParams(ArrayNode params) {
        node.put("params", params);
    }

    public void setParams(HashMap<String, String> params) {
        ArrayNode arrayNode = mapper.createArrayNode();
        ObjectNode objectNode = mapper.createObjectNode();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            objectNode.put(entry.getKey(),entry.getValue());
        }
        arrayNode.add(objectNode);
        arrayNode.add("latest");
        node.put("params", arrayNode);
    }

    @Override
    public String toString() {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(node);
        } catch (JsonProcessingException e) {
            logger.error("Error building request: " + e.getMessage());
            return "";
        }
    }

    // Only use if you know what you're doing
    public ObjectMapper getMapper() {
        return mapper;
    }
}