package com.miketheshadow.cryptolib.request;


import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.containers.*;
import com.miketheshadow.cryptolib.containers.transaction.ToFromTransactions;
import com.miketheshadow.cryptolib.containers.transaction.TransactionInfo;

public class Requests {

    CryptoLib lib;

    public Requests(CryptoLib lib) {
        this.lib = lib;
        createRequests();
    }

    private void createRequests() {
        GENERIC_REQUEST = new BlockChainRequest<>(GenericRequest.class, lib);
        TRANSACTION_DATA_REQUEST = new BlockChainRequest<>(TransactionData.class, lib);
        TRANSACTION_LOG_REQUEST = new BlockChainRequest<>(TransactionLog.class, lib);
        BLOCK_INFO_REQUEST = new BlockChainRequest<>(LatestBlockContainer.class, lib);
        TO_FROM_TRANSACTIONS_REQUEST = new BlockChainRequest<>(ToFromTransactions.class, lib);
        TRANSACTION_INFO_REQUEST = new BlockChainRequest<>(TransactionInfo.class, lib);
    }

    public BlockChainRequest<GenericRequest> GENERIC_REQUEST;
    public BlockChainRequest<TransactionData> TRANSACTION_DATA_REQUEST;
    public BlockChainRequest<TransactionLog> TRANSACTION_LOG_REQUEST;
    public BlockChainRequest<LatestBlockContainer> BLOCK_INFO_REQUEST;
    public BlockChainRequest<ToFromTransactions> TO_FROM_TRANSACTIONS_REQUEST;
    public BlockChainRequest<TransactionInfo> TRANSACTION_INFO_REQUEST;

}