/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib;

import com.miketheshadow.cryptolib.utils.BlockUtils;
import com.miketheshadow.cryptolib.utils.ContractUtils;
import com.miketheshadow.cryptolib.utils.RequestException;
import com.miketheshadow.cryptolib.utils.Requests;
import com.miketheshadow.cryptolib.utils.WalletUtils;

public class CryptoLib {
    String nodeString;
    String contract;
    double totalSupply;
    int zeros;
    public Requests requests;
    public WalletUtils walletUtils;
    public ContractUtils contractUtils;
    public BlockUtils blockUtils;
    String deadAddress = "0x000000000000000000000000000000000000dead";
    String archiveNodeString;
    boolean hasArchiveNodeSupport = false;

    public CryptoLib(String nodeString, String contract) throws RequestException {
        this.nodeString = nodeString;
        this.contract = contract;
        this.requests = new Requests(this);
        this.blockUtils = new BlockUtils(this);
        this.contractUtils = new ContractUtils(this);
        this.walletUtils = new WalletUtils(this);
        this.zeros = this.contractUtils.getZeros();
    }

    public String getNodeString() {
        return this.nodeString;
    }

    public String getContract() {
        return this.contract;
    }

    public double getTotalSupply() throws RequestException {
        this.totalSupply = this.contractUtils.getTotalSupply();
        return this.totalSupply;
    }

    public double getTotalSupplyNonUpdating() {
        return this.totalSupply;
    }

    public int getZeros() {
        return this.zeros;
    }

    public String getDeadAddress() {
        return this.deadAddress;
    }

    public CryptoLib setDeadAddress(String address) {
        this.deadAddress = address;
        return this;
    }

    public CryptoLib addArchiveNodeSupport(String archiveNodeString) {
        this.archiveNodeString = archiveNodeString;
        this.hasArchiveNodeSupport = true;
        return this;
    }

    public String getArchiveNodeString() {
        return this.archiveNodeString;
    }

    public boolean hasArchiveNodeSupport() {
        return this.hasArchiveNodeSupport;
    }
}

