package com.miketheshadow.cryptolib;


import com.miketheshadow.cryptolib.utils.*;

public class CryptoLib {

    String nodeString;
    String contract;
    //TODO make this a request-based feature to account for
    //TODO changing total supplies
    double totalSupply;
    int zeros;
    public Requests requests;
    public WalletUtils walletUtils;
    public ContractUtils contractUtils;
    public BlockUtils blockUtils;
    String deadAddress = "0x000000000000000000000000000000000000dead";
    String archiveNodeString;
    boolean hasArchiveNodeSupport = false;


    public CryptoLib(String nodeString, String contract) throws RequestException {
        this.nodeString = nodeString;
        this.contract = contract;
        this.requests = new Requests(this);
        this.blockUtils = new BlockUtils(this);
        this.contractUtils = new ContractUtils(this);
        this.walletUtils = new WalletUtils(this);
        this.zeros = contractUtils.getZeros();
    }

    public String getNodeString() {
        return nodeString;
    }

    public String getContract() {
        return contract;
    }

    public double getTotalSupply() throws RequestException {
        this.totalSupply = contractUtils.getTotalSupply();
        return totalSupply;
    }

    public double getTotalSupplyNonUpdating() {
        return this.totalSupply;
    }

    public int getZeros() {
        return zeros;
    }

    public String getDeadAddress() {
        return deadAddress;
    }

    public CryptoLib setDeadAddress(String address) {
        this.deadAddress = address;
        return this;
    }

    public CryptoLib addArchiveNodeSupport(String archiveNodeString) {
        this.archiveNodeString = archiveNodeString;
        this.hasArchiveNodeSupport = true;
        return this;
    }

    public String getArchiveNodeString() {
        return archiveNodeString;
    }

    public boolean hasArchiveNodeSupport() {
        return hasArchiveNodeSupport;
    }
}
