package com.miketheshadow.cryptolib.utils.bulkrequest;

import com.miketheshadow.cryptolib.CryptoLib;

public class BulkHolderRequestable implements Requestable {

    String address;
    CryptoLib lib;

    public BulkHolderRequestable(String address, CryptoLib lib) {
        this.address = address;
        this.lib = lib;
    }

    @Override
    public String getAsRequest(int id) {
        return "{\r\n  \"jsonrpc\": \"2.0\",\r\n  \"id\": " + id + ",\r\n  \"method\": \"eth_call\",\r\n  \"params\": [\r\n    {\r\n      \"data\": \"0x70a08231000000000000000000000000" + address.replace("0x","") + "\",\r\n      \"to\": \"" + lib.getContract() + "\"\r\n    },\r\n    \"latest\"\r\n  ]\r\n}\r\n";

    }

    @Override
    public int requestSize() {
        return 1;
    }

    public String getAddress() {
        return address;
    }
}
