package com.miketheshadow.cryptolib.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.miketheshadow.cryptolib.CryptoLib;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public record BlockChainRequest<T>(Class<T> type, CryptoLib lib) {

    private static final Logger logger = LoggerFactory.getLogger(BlockChainRequest.class);


    public T requestChainInfo(String data) throws RequestException {
        return requestChainInfo(data,lib.getNodeString());
    }

    public T requestChainInfo(String data,String node) throws RequestException {
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        MediaType mediaType = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(mediaType, data);
        Request request = new Request.Builder()
                .url(node)
                .method("POST", body)
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            String bodyString;
            try (Response response = client.newCall(request).execute()) {
                bodyString = response.body().string();
            } catch (IOException e) {
                throw new RequestException(e);
            }
            return (new ObjectMapper()).readValue(bodyString, type);
        } catch (JsonProcessingException e) {
            throw new RequestException("Bad request: " + e.getMessage() + " | " + lib.getNodeString() + " | " + type.getName());
        }
    }

}