/*
 * Decompiled with CFR 0.152.
 */
package com.miketheshadow.cryptolib.utils.bulkrequest;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.miketheshadow.cryptolib.CryptoLib;
import com.miketheshadow.cryptolib.utils.RequestException;
import com.miketheshadow.cryptolib.utils.bulkrequest.Requestable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkRequest<T> {
    Logger logger = LoggerFactory.getLogger(BulkRequest.class);
    private final List<? extends Requestable> requestables;
    private final Class<?> mapping;
    private final CryptoLib lib;
    private final boolean retryOnError;
    private int delay = 0;

    public BulkRequest(CryptoLib lib, List<? extends Requestable> requestables, Class<?> mapping, boolean retryOnError) {
        this.lib = lib;
        this.requestables = requestables;
        this.mapping = mapping;
        this.retryOnError = retryOnError;
    }

    public BulkRequest<T> withDelay(int seconds) {
        this.delay = seconds;
        return this;
    }

    public List<T> get() throws RequestException {
        ArrayList<T> result = new ArrayList<T>();
        for (String requestString : this.generateBulkRequests()) {
            try {
                MediaType mediaType = MediaType.parse("application/json");
                RequestBody body = RequestBody.create(mediaType, requestString);
                Request request = new Request.Builder().url(this.lib.getNodeString()).method("POST", body).addHeader("Content-Type", "application/json").build();
                List<T> values2 = this.executeRequest(request);
                if (values2 == null) {
                    throw new RequestException("Unable to update Bulk Requests!");
                }
                result.addAll(values2);
            }
            catch (RequestException requestException) {
                if (!this.retryOnError) {
                    throw new RequestException(requestException);
                }
                this.logger.warn("Bulk Request errored however retryOnError is true: " + requestException.getMessage());
            }
            if (this.delay <= 0) continue;
            try {
                Thread.sleep((long)this.delay * 1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private List<String> generateBulkRequests() {
        List<List<? extends Requestable>> requestLists = Lists.partition(this.requestables, 500 / this.requestables.get(0).requestSize());
        ArrayList<String> requestStrings = new ArrayList<String>();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (List<? extends Requestable> list : requestLists) {
            requestStrings.add(this.generateRequest(list, atomicInteger));
        }
        return requestStrings;
    }

    private String generateRequest(List<? extends Requestable> requests, AtomicInteger startIndex) {
        Joiner joiner = Joiner.on(",");
        return "[" + joiner.join(requests.stream().map(requestable -> requestable.getAsRequest(startIndex.getAndIncrement())).toList()) + "]";
    }

    private List<T> executeRequest(Request request) {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Response response = client.newCall(request).execute();
        try {
            String bodyString = response.body().string();
            ObjectMapper mapper = new ObjectMapper();
            JavaType type = BulkRequest.getCollectionType(mapper, List.class, this.mapping);
            List list = (List)mapper.readValue(bodyString, type);
            if (response != null) {
                response.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static JavaType getCollectionType(ObjectMapper mapper, Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }
}

