/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.classic.util.DefaultJoranConfigurator;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.net.URL;
import java.util.Comparator;
import java.util.List;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public void configureByResource(URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String urlString = url.toString();
        if (!urlString.endsWith("xml")) {
            throw new LogbackException("Unexpected filename extension of file [" + url + "]. Should be .xml");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(this.loggerContext);
        configurator.doConfigure(url);
    }

    void joranConfigureByResource(URL url) throws JoranException {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(this.loggerContext);
        configurator.doConfigure(url);
    }

    public void autoConfig() throws JoranException {
        this.autoConfig(Configurator.class.getClassLoader());
    }

    public void autoConfig(ClassLoader classLoader) throws JoranException {
        String versionStr = EnvUtil.logbackVersion();
        this.loggerContext.getStatusManager().add(new InfoStatus("This is logback-classic version " + versionStr, this.loggerContext));
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        List<Configurator> configuratorList = ClassicEnvUtil.loadFromServiceLoader(Configurator.class, classLoader);
        this.sortByPriority(configuratorList);
        for (Configurator c : configuratorList) {
            try {
                c.setContext(this.loggerContext);
                Configurator.ExecutionStatus status = c.configure(this.loggerContext);
                if (status != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
                return;
            }
            catch (Exception e) {
                throw new LogbackException(String.format("Failed to initialize Configurator: %s using ServiceLoader", c != null ? c.getClass().getCanonicalName() : "null"), e);
            }
        }
        BasicConfigurator basicConfigurator = new BasicConfigurator();
        basicConfigurator.setContext(this.loggerContext);
        basicConfigurator.configure(this.loggerContext);
    }

    private void sortByPriority(List<Configurator> configuratorList) {
        configuratorList.sort(new Comparator<Configurator>(){

            @Override
            public int compare(Configurator o1, Configurator o2) {
                if (o1.getClass() == o2.getClass()) {
                    return 0;
                }
                if (o1 instanceof DefaultJoranConfigurator) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

